<?php

require_once "conexion.php";

class ModeloServicios{

	/*=============================================
	CREAR SERVICIO
	=============================================*/

	static public function mdlIngresarServicio($tabla, $datos){

		$stmt = Conexion::conectar()->prepare("INSERT INTO $tabla(nombre, descripcion, cantidad_bolsa, valor_servicio) VALUES (:nombre, :descripcion, :cantidad_bolsa, :valor_servicio)");


		$stmt->bindParam(":nombre", $datos["nombre"], PDO::PARAM_STR);
		$stmt->bindParam(":descripcion", $datos["descripcion"], PDO::PARAM_STR);
		$stmt->bindParam(":cantidad_bolsa", $datos["cantidad_bolsa"], PDO::PARAM_STR);
		$stmt->bindParam(":valor_servicio", $datos["valor_servicio"], PDO::PARAM_STR);



		if($stmt->execute()){

			return "ok";

		}else{

			return "error";

		}

		$stmt = null;

	}


	/*=============================================
	MOSTRAR SERVICIO
	=============================================*/

	static public function mdlMostrarServicios($tabla, $item, $valor, $estado = null){

		if($item != null){

			$stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla WHERE $item = :$item");

			$stmt -> bindParam(":".$item, $valor, PDO::PARAM_STR);

			$stmt -> execute();

			$resultado = $stmt -> fetch(PDO::FETCH_ASSOC);
			return $resultado ? $resultado : false;

		}else{
			if($estado != null){
				$stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla where estado = 'activo'");
			} else {
				$stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla");
			}

			$stmt -> execute();

			$resultado = $stmt -> fetchAll(PDO::FETCH_ASSOC);
			return is_array($resultado) ? $resultado : array();

		}


		$stmt = null;

	}

	static public function mdlMostrarContratosServicios($tabla, $item, $valor,$valor2,$valor3){
		//idtipo_servicio != vacio y estado servicio != vacio y zona_servicio != vacio
		if($valor != "" && $valor2 != "" && $valor3 != ""){
			$stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla WHERE idtipo_servicios = :item AND estado = :estado AND idzona = :zona");

				$stmt -> bindParam(":item", $valor, PDO::PARAM_STR);
				$stmt -> bindParam(":estado", $valor2, PDO::PARAM_INT);
				$stmt -> bindParam(":zona", $valor3, PDO::PARAM_STR);

				$stmt -> execute();

				return $stmt -> fetchAll();
		//idtipo_servicio != vacio y estado servicio != vacio
		}else if ($valor != "" && $valor2 != ""){
			$stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla WHERE idtipo_servicios = :item AND estado = :estado");

				$stmt -> bindParam(":item", $valor, PDO::PARAM_STR);
				$stmt -> bindParam(":estado", $valor2, PDO::PARAM_INT);

				$stmt -> execute();

				return $stmt -> fetchAll();
		//idtipo_servicio != vacio y zona_servicio != vacio
		}else if($valor != "" && $valor3 != ""){
			$stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla WHERE idtipo_servicios = :item AND idzona = :zona");

				$stmt -> bindParam(":item", $valor, PDO::PARAM_STR);
				$stmt -> bindParam(":zona", $valor3, PDO::PARAM_STR);

				$stmt -> execute();

				return $stmt -> fetchAll();
		//estado servicio != vacio y zona_servicio != vacio
		}else if($valor2 != "" && $valor3 != ""){
			$stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla WHERE estado = :estado AND idzona = :zona");

				$stmt -> bindParam(":estado", $valor2, PDO::PARAM_INT);
				$stmt -> bindParam(":zona", $valor3, PDO::PARAM_STR);

				$stmt -> execute();

				return $stmt -> fetchAll();
		//zona_servicio != vacio
		}else if($valor3 != ""){
			$stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla WHERE idzona = :zona");

				$stmt -> bindParam(":zona", $valor3, PDO::PARAM_STR);

				$stmt -> execute();

				return $stmt -> fetchAll();
		//estado servicio != vacio
		}else if($valor2 != ""){
			$stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla WHERE estado = :estado");

				$stmt -> bindParam(":estado", $valor2, PDO::PARAM_INT);

				$stmt -> execute();

				return $stmt -> fetchAll();
		//idtipo_servicio != vacio
		}else if($valor != ""){
			$stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla WHERE idtipo_servicios = :item");

				$stmt -> bindParam(":item", $valor, PDO::PARAM_STR);

				$stmt -> execute();

				return $stmt -> fetchAll();
		}else{
			$stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla");

			$stmt -> execute();

			return $stmt -> fetchAll();
		}



		$stmt = null;

	}
	static public function mdlMostrarporBloques($tabla, $item, $valor,$valor2,$valor3){
		//idtipo_servicio != vacio y estado servicio != vacio y zona_servicio != vacio
		if($valor != "" && $valor2 != "" && $valor3 != ""){
			$stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla WHERE idtipo_servicios = :item AND estado = :estado AND BLOQUE = :zona");

				$stmt -> bindParam(":item", $valor, PDO::PARAM_STR);
				$stmt -> bindParam(":estado", $valor2, PDO::PARAM_INT);
				$stmt -> bindParam(":zona", $valor3, PDO::PARAM_STR);

				$stmt -> execute();

				return $stmt -> fetchAll();
		//idtipo_servicio != vacio y estado servicio != vacio
		}else if ($valor != "" && $valor2 != ""){
			$stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla WHERE idtipo_servicios = :item AND estado = :estado");

				$stmt -> bindParam(":item", $valor, PDO::PARAM_STR);
				$stmt -> bindParam(":estado", $valor2, PDO::PARAM_INT);

				$stmt -> execute();

				return $stmt -> fetchAll();
		//idtipo_servicio != vacio y zona_servicio != vacio
		}else if($valor != "" && $valor3 != ""){
			$stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla WHERE idtipo_servicios = :item AND BLOQUE = :zona");

				$stmt -> bindParam(":item", $valor, PDO::PARAM_STR);
				$stmt -> bindParam(":zona", $valor3, PDO::PARAM_STR);

				$stmt -> execute();

				return $stmt -> fetchAll();
		//estado servicio != vacio y zona_servicio != vacio
		}else if($valor2 != "" && $valor3 != ""){
			$stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla WHERE estado = :estado AND BLOQUE = :zona");

				$stmt -> bindParam(":estado", $valor2, PDO::PARAM_INT);
				$stmt -> bindParam(":zona", $valor3, PDO::PARAM_STR);

				$stmt -> execute();

				return $stmt -> fetchAll();
		//zona_servicio != vacio
		}else if($valor3 != ""){
			$stmt = Conexion::conectar()->prepare("SELECT * FROM `general_recuperacion` WHERE `BLOQUE` = :zona");

				$stmt -> bindParam(":zona", $valor3, PDO::PARAM_STR);

				$stmt -> execute();

				return $stmt -> fetchAll();
		//estado servicio != vacio
		}else if($valor2 != ""){
			$stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla WHERE estado = :estado");

				$stmt -> bindParam(":estado", $valor2, PDO::PARAM_INT);

				$stmt -> execute();

				return $stmt -> fetchAll();
		//idtipo_servicio != vacio
		}else if($valor != ""){
			$stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla WHERE idtipo_servicios = :item");

				$stmt -> bindParam(":item", $valor, PDO::PARAM_STR);

				$stmt -> execute();

				return $stmt -> fetchAll();
		}else{
			$stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla");

			$stmt -> execute();

			return $stmt -> fetchAll();
		}



		$stmt = null;
}    

// aqui va el detallado de reporte para contabilidad y generar un excel 

static public function mdlMostrarporConta($tabla, $item, $valor,$valor2,$valor3){
		//idtipo_servicio != vacio y estado servicio != vacio y zona_servicio != vacio
		if($valor != "" && $valor2 != "" && $valor3 != ""){
			$stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla WHERE DATE_FORMAT(`FECHA_ACORDADA`, '%Y-%m') = :item AND `ESTADO_DEL_PAGO` = :estado AND BLOQUE = :zona");

				$stmt -> bindParam(":item", $valor, PDO::PARAM_STR);
				$stmt -> bindParam(":estado", $valor2, PDO::PARAM_STR);
				$stmt -> bindParam(":zona", $valor3, PDO::PARAM_STR);

				$stmt -> execute();

				return $stmt -> fetchAll();
		//idtipo_servicio != vacio y estado servicio != vacio
		}else if ($valor != "" && $valor2 != ""){
			$stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla WHERE DATE_FORMAT(`FECHA_ACORDADA`, '%Y-%m') = :item AND `ESTADO_DEL_PAGO` = :estado");

				$stmt -> bindParam(":item", $valor, PDO::PARAM_STR);
				$stmt -> bindParam(":estado", $valor2, PDO::PARAM_STR);

				$stmt -> execute();

				return $stmt -> fetchAll();
		//idtipo_servicio != vacio y zona_servicio != vacio
		}else if($valor != "" && $valor3 != ""){
			$stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla WHERE DATE_FORMAT(`FECHA_ACORDADA`, '%Y-%m') = :item AND BLOQUE = :zona");

				$stmt -> bindParam(":item", $valor, PDO::PARAM_STR);
				$stmt -> bindParam(":zona", $valor3, PDO::PARAM_STR);

				$stmt -> execute();

				return $stmt -> fetchAll();
		//estado servicio != vacio y zona_servicio != vacio
		}else if($valor2 != "" && $valor3 != ""){
			$stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla WHERE `ESTADO_DEL_PAGO` = :estado AND BLOQUE = :zona");

				$stmt -> bindParam(":estado", $valor2, PDO::PARAM_STR);
				$stmt -> bindParam(":zona", $valor3, PDO::PARAM_STR);

				$stmt -> execute();

				return $stmt -> fetchAll();
		//zona_servicio != vacio
		}else if($valor3 != ""){
			$stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla WHERE `BLOQUE` = :zona");

				$stmt -> bindParam(":zona", $valor3, PDO::PARAM_STR);

				$stmt -> execute();

				return $stmt -> fetchAll();
		//estado servicio != vacio
		}else if($valor2 != ""){
			$stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla WHERE `ESTADO_DEL_PAGO` = :estado");

				$stmt -> bindParam(":estado", $valor2, PDO::PARAM_STR);

				$stmt -> execute();

				return $stmt -> fetchAll();
		//idtipo_servicio != vacio
		}else if($valor != ""){
			$stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla WHERE DATE_FORMAT(`FECHA_ACORDADA`, '%Y-%m') = :item");

				$stmt -> bindParam(":item", $valor, PDO::PARAM_STR);

				$stmt -> execute();

				return $stmt -> fetchAll();
		}else{
			$stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla");

			$stmt -> execute();

			return $stmt -> fetchAll();
		}



		$stmt = null;
}
// aqui termina

        static public function mdlMostrarporGeneral($tabla, $item, $valor,$valor2,$valor3){
		//idtipo_servicio != vacio y estado servicio != vacio y zona_servicio != vacio
		if($valor != "" && $valor2 != "" && $valor3 != ""){
			$stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla WHERE idtipo_servicios = :item AND estado = :estado AND BLOQUE = :zona");

				$stmt -> bindParam(":item", $valor, PDO::PARAM_STR);
				$stmt -> bindParam(":estado", $valor2, PDO::PARAM_INT);
				$stmt -> bindParam(":zona", $valor3, PDO::PARAM_STR);

				$stmt -> execute();

				return $stmt -> fetchAll();
		//idtipo_servicio != vacio y estado servicio != vacio
		}else if ($valor != "" && $valor2 != ""){
			$stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla WHERE idtipo_servicios = :item AND estado = :estado");

				$stmt -> bindParam(":item", $valor, PDO::PARAM_STR);
				$stmt -> bindParam(":estado", $valor2, PDO::PARAM_INT);

				$stmt -> execute();

				return $stmt -> fetchAll();
		//idtipo_servicio != vacio y zona_servicio != vacio
		}else if($valor != "" && $valor3 != ""){
			$stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla WHERE idtipo_servicios = :item AND BLOQUE = :zona");

				$stmt -> bindParam(":item", $valor, PDO::PARAM_STR);
				$stmt -> bindParam(":zona", $valor3, PDO::PARAM_STR);

				$stmt -> execute();

				return $stmt -> fetchAll();
		//estado servicio != vacio y zona_servicio != vacio
		}else if($valor2 != "" && $valor3 != ""){
			$stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla WHERE estado = :estado AND BLOQUE = :zona");

				$stmt -> bindParam(":estado", $valor2, PDO::PARAM_INT);
				$stmt -> bindParam(":zona", $valor3, PDO::PARAM_STR);

				$stmt -> execute();

				return $stmt -> fetchAll();
		//zona_servicio != vacio
		}else if($valor3 != ""){
			$stmt = Conexion::conectar()->prepare("SELECT * FROM `detalle_pagos` WHERE `BLOQUE` = :zona");

				$stmt -> bindParam(":zona", $valor3, PDO::PARAM_STR);

				$stmt -> execute();

				return $stmt -> fetchAll();
		//estado servicio != vacio
		}else if($valor2 != ""){
			$stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla WHERE estado = :estado");

				$stmt -> bindParam(":estado", $valor2, PDO::PARAM_INT);

				$stmt -> execute();

				return $stmt -> fetchAll();
		//idtipo_servicio != vacio
		}else if($valor != ""){
			$stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla WHERE idtipo_servicios = :item");

				$stmt -> bindParam(":item", $valor, PDO::PARAM_STR);

				$stmt -> execute();

				return $stmt -> fetchAll();
		}else{
			$stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla");

			$stmt -> execute();

			return $stmt -> fetchAll();
		}



		$stmt = null;
}



	/*=============================================
	EDITAR SERVICIO
	=============================================*/

	static public function mdlEditarServicio($tabla, $datos){

		$stmt = Conexion::conectar()->prepare("UPDATE $tabla SET nombre =:nombre, descripcion =:descripcion, cantidad_bolsa =:cantidad_bolsa, valor_servicio =:valor_servicio WHERE idtipo_servicios = :idtipo_servicios");

		$stmt->bindParam(":idtipo_servicios", $datos["idtipo_servicios"], PDO::PARAM_INT);
		$stmt->bindParam(":nombre", $datos["nombre"], PDO::PARAM_STR);
		$stmt->bindParam(":descripcion", $datos["descripcion"], PDO::PARAM_STR);
		$stmt->bindParam(":cantidad_bolsa", $datos["cantidad_bolsa"], PDO::PARAM_STR);
		$stmt->bindParam(":valor_servicio", $datos["valor_servicio"], PDO::PARAM_STR);



		if($stmt->execute()){

			return "ok";

		}else{

			return "error";

		}

		$stmt = null;

	}

	/*=============================================
	ELIMINAR SERVICIO
	=============================================*/

	static public function mdlEliminarServicio($tabla, $datos){

		$stmt = Conexion::conectar()->prepare("DELETE FROM $tabla WHERE idtipo_servicios = :idtipo_servicios");

		$stmt -> bindParam(":idtipo_servicios", $datos, PDO::PARAM_INT);

		if($stmt -> execute()){

			return "ok";

		}else{

			return "error";

		}


		$stmt = null;

	}

			/*=============================================
	ACTUALIZAR ESTADO SERVICIO
	=============================================*/

	static public function mdlActualizarEstadoServicio($tabla, $item1, $valor1, $item2, $valor2){

		$stmt = Conexion::conectar()->prepare("UPDATE $tabla SET $item1 = :$item1 WHERE $item2 = :$item2");

		$stmt -> bindParam(":".$item1, $valor1, PDO::PARAM_STR);
		$stmt -> bindParam(":".$item2, $valor2, PDO::PARAM_STR);

		if($stmt -> execute()){

			return "ok";

		}else{

			return "error";

		}


		$stmt = null;

	}




}
